
/**
 ******************************************************************************
 *
 * @file        MG32_DACOutput_API.h
 * @brief       This file contains all the functions prototypes for the DAC 
 *              firmware library.
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2022/09/26
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef _MG32_DACOutput_API_
#define _MG32_DACOutput_API_


/* Includes ------------------------------------------------------------------*/
#include "MG32_DAC_MID.h"
#include "MG32_DMA_MID.h"
#include "MG32_TM_MID.h"
#include "MG32_GPIO_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/** 
 * @enum        API_DAC_DataFreqDef
 * @brief       API DAC Data Frequency Definintion
 */        
typedef enum 
{
    MID_DAC_16K                 = (0x00000000U),   /*!< DAC not yet initialized or disabled.             */
    MID_DAC_8K                  = (0x00000001U),   /*!< DAC initialized and ready for use.               */
}API_DAC_DataFreqDef;

/** 
 * @enum        API_DAC_DataSourceDef
 * @brief       API DAC Data Source Definintion
 */        
typedef enum 
{
    DAC_DATA_FLASH,                                 /*!< DAC data from flash IC.                          */
    DAC_DATA_USB,                                   /*!< DAC data from USB.                               */
}API_DAC_DataSourceDef;

/** 
 * @struct  API_DAC_Parameters
 * @brief   Structure definition of DAC initialization and regular group 
 */        
typedef struct
{
    uint32_t    State;                      /*!< Selects the DAC state. This parameter can be a value of reference API_DAC_StateDef.                */
    uint8_t     AudioVolume;                /*!< Selects the DAC data volume. This parameter can be a value of 0~6.                                 */
    uint8_t     SongsSelect;                /*!< Selects the DAC data source from flash. This parameter can be a value of 1~3.                      */
    uint8_t     AudioDataFreq;              /*!< Selects the DAC data frequency. This parameter can be a value of reference API_DAC_DataFreqDef.    */
    uint8_t     AudioSource;                /*!< Selects the DAC data source. This parameter can be DAC_DATA_FLASH or DAC_DATA_USB.                 */
    uint16_t    AudioBufIDX;                /*!< AudioBufIDX : the index of audio data source 512x.                                                 */
    uint8_t     __Reserved[2];              /*!< Reserved byte                                                                                      */
}API_DAC_Parameters;

/* Private define ------------------------------------------------------------*/
/** 
 * @enum        API_DAC_StateDef
 * @brief       API DAC State Definintion
 */
#define ResetAudioState     160000

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/*  Function used to set the DAC configuration to the default reset state *****/
void API_DACOutput_Init(void);
void API_DAC_StartOutput(void);
void API_DAC_PauseOutput(void);
void API_DAC_StartUSBOutput(uint8_t DataFreq);
void API_DACOutputData_Update(void);

/* Exported variables --------------------------------------------------------*/
extern TM_HandleTypeDef    mTM10;
extern API_DAC_Parameters  API_DAC_Output;
extern DAC_HandleTypeDef   mDAC;

/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


#endif

